﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Kasa" %>
<script runat="server">

	public class Confirmation: ContextBase {
	
		public Confirmation(Context context): base(context) {
		}
		
		bool confirm = false;
		[Caption("Wykonać przeliczenie")]
		public bool Confirm {
			get { return confirm; }
			set { 
				confirm = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}

	Confirmation pars;
	[Context]
	public Confirmation Pars {
		get { return pars; }
		set { pars = value; }
	}

  void dc_ContextLoad(Object sender, EventArgs e) {
		if (!pars.Confirm)		
			throw new Exception("Anulowano przeliczenie");
			
		Log log = new Log(Log.Progress);
		Row[] rows = (Row[])dc[typeof(Row[])];
		int c = rows.Length;
		int i = 0;
		Database database = dc.Session.Login.Database;
    MsSqlDatabase mssql = database as MsSqlDatabase;
		Session session = dc.Session.Login.CreateSessionX();
		using (ITransaction t = session.Logout(true)) {
			foreach (IRozliczalny rozliczalny in rows) {
				log.WriteLine(new Percent((decimal)++i/c));
				Platnosc zap = rozliczalny as Platnosc;
				if(zap==null || zap.Rozliczana)
					continue;
				try {
					if (mssql != null)
						mssql.ExecuteCommand(ExecuteMode.WorkDB, "EXECUTE dbo.OpenSession");								
					session.Login.Database.ExecuteCommand(
						Soneta.Business.App.ExecuteMode.WorkDB,
						string.Format("update Platnosci set Rozliczana = 1 where id = {0}",zap.ID));
					session.Login.Database.ExecuteCommand(
						Soneta.Business.App.ExecuteMode.WorkDB,
                        string.Format("insert into RozrachunkiIdx (DokumentType,Dokument,EwidencjaSP, DataRozliczenia,DataPierwszego,Data,Typ,Numer) values ('Platnosci',{0},{1},'2004-1-1','2004-1-1','2004-1-1',1,'aaaa')", zap.ID, zap.EwidencjaSP.ID ));
				} finally {
					if (mssql != null)
						mssql.ExecuteCommand(ExecuteMode.WorkDB, "EXECUTE dbo.CloseSession");
				}						
				IRozliczalny r = (IRozliczalny)session[(Row)rozliczalny];
				RozrachunkiIdx.Przelicz(r);
			}	                    
			t.CommitUI();
		}
		session.Save();
		throw new CancelException();
  }
    
	static void Msg(object value) {
	}    

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Tools</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    </form>
</body>
</html>
